/*
 * Decompiled with CFR 0.152.
 */
package jclass.chart;

import java.awt.Container;
import java.awt.Graphics;
import java.awt.Point;
import jclass.bwt.JCSerializable;
import jclass.chart.ChartDataView;
import jclass.chart.ChartText;
import jclass.chart.JCChart;
import jclass.chart.JCChartEvent;
import jclass.chart.JCChartListener;
import jclass.chart.JCDataCoord;
import jclass.chart.JCDataIndex;
import jclass.chart.JCTitle;

public class JCChartLabel
extends JCTitle
implements JCSerializable,
JCChartListener {
    public static final int NORTHEAST = 1;
    public static final int NORTH = 2;
    public static final int NORTHWEST = 3;
    public static final int EAST = 4;
    public static final int WEST = 5;
    public static final int SOUTHEAST = 6;
    public static final int SOUTH = 7;
    public static final int SOUTHWEST = 8;
    public static final int CENTER = 9;
    public static final int AUTO = 10;
    public static final int ATTACH_NONE = 0;
    public static final int ATTACH_COORD = 1;
    public static final int ATTACH_DATACOORD = 2;
    public static final int ATTACH_DATAINDEX = 3;
    int anchor = 9;
    int attachMethod = 1;
    int attachX;
    int attachY;
    double dataAttachX;
    double dataAttachY;
    int offsetX;
    int offsetY;
    JCDataIndex attachDataIndex;
    ChartDataView dataView;
    boolean isDwellLabel = false;
    int dwellDelay;

    public JCChartLabel(String string, boolean bl) {
        this.label = new ChartText(this, string, bl);
        this.isShowing = true;
    }

    public JCChartLabel() {
        this.label = new ChartText(this, "label", false);
        this.isShowing = true;
    }

    public void addNotify() {
        super.addNotify();
        this.recalc();
    }

    public void recalc() {
        Point point;
        this.setChanged(true, false);
        super.recalc();
        ChartDataView chartDataView = this.getDataView();
        if (chartDataView == null) {
            return;
        }
        int n = this.getWidth() / 2;
        int n2 = this.getHeight() / 2;
        try {
            switch (this.attachMethod) {
                case 1: {
                    point = new Point(this.attachX, this.attachY);
                    break;
                }
                case 2: {
                    point = chartDataView.dataCoordToCoord(this.dataAttachX, this.dataAttachY);
                    break;
                }
                case 3: {
                    point = chartDataView.dataIndexToCoord(this.attachDataIndex);
                    try {
                        Point point2 = this.getChart().getChartArea().location();
                        point.x -= point2.x;
                        point.y -= point2.y;
                    }
                    catch (Exception exception) {}
                    break;
                }
                default: {
                    return;
                }
            }
        }
        catch (Exception exception) {
            point = null;
        }
        if (point == null) {
            point = new Point(-9999, -9999);
        } else {
            point.x -= n;
            point.y -= n2;
            switch (this.anchor) {
                case 1: 
                case 4: 
                case 6: {
                    point.x += n;
                    break;
                }
                case 3: 
                case 5: 
                case 8: {
                    point.x -= n;
                    break;
                }
            }
            switch (this.anchor) {
                case 1: 
                case 2: 
                case 3: {
                    point.y -= n2;
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    point.y += n2;
                    break;
                }
            }
            point.x += this.offsetX;
            point.y += this.offsetY;
            this.setChanged(false);
        }
        this.move(point.x, point.y);
    }

    public void paint(Graphics graphics) {
        this.recalc();
        super.paint(graphics);
    }

    public void paintComponent(Graphics graphics) {
        this.recalc();
        super.paintComponent(graphics);
    }

    public synchronized void setAnchor(int n) {
        if (n == this.anchor) {
            return;
        }
        switch (n) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                this.anchor = n;
                this.setChanged(true);
                return;
            }
        }
        throw new IllegalArgumentException("Invalid Anchor value in JCChartLabel.  Should be one of NORTH, SOUTH, EAST, WEST, NORTHEAST, SOUTHEAST, NORTHWEST, SOUTHWEST, CENTER or AUTO.");
    }

    public int getAnchor() {
        return this.anchor;
    }

    public void setAttachMethod(int n) {
        if (n == this.attachMethod) {
            return;
        }
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                this.attachMethod = n;
                this.setChanged(true);
                return;
            }
        }
        throw new IllegalArgumentException("Invalid AttachMethod in JCChartLabel. Should be one of ATTACH_NONE, ATTACH_COORD, ATTACH_DATACOORD, ATTACH_DATAINDEX.");
    }

    public int getAttachMethod() {
        return this.attachMethod;
    }

    public void setCoord(Point point) {
        this.attachX = point.x;
        this.attachY = point.y;
        this.setChanged(true);
    }

    public Point getCoord() {
        return new Point(this.attachX, this.attachY);
    }

    public void setDataView(ChartDataView chartDataView) {
        this.dataView = chartDataView;
        this.setChanged(true);
    }

    public ChartDataView getDataView() {
        try {
            if (this.dataView == null) {
                return this.chart.getDataView(0);
            }
            return this.dataView;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void setDataCoord(JCDataCoord jCDataCoord) {
        this.dataAttachX = jCDataCoord.x;
        this.dataAttachY = jCDataCoord.y;
        this.setChanged(true);
        this.recalc();
    }

    public JCDataCoord getDataCoord() {
        return new JCDataCoord(this.dataAttachX, this.dataAttachY);
    }

    public void setDataIndex(JCDataIndex jCDataIndex) {
        this.attachDataIndex = jCDataIndex;
        this.setChanged(true);
        this.recalc();
    }

    public JCDataIndex getDataIndex() {
        return this.attachDataIndex;
    }

    public void setOffset(Point point) {
        this.offsetX = point.x;
        this.offsetY = point.y;
        this.setChanged(true);
        this.recalc();
    }

    public Point getOffset() {
        return new Point(this.offsetX, this.offsetY);
    }

    public void setIsDwellLabel(boolean bl) {
        if (bl == this.isDwellLabel) {
            return;
        }
        this.isDwellLabel = bl;
        if (this.chart != null) {
            if (bl) {
                this.chart.addToDwellLabels(this);
                this.hide();
            } else {
                this.chart.removeFromDwellLabels(this);
                this.show();
            }
        }
        this.setChanged(true);
    }

    public boolean getIsDwellLabel() {
        return this.isDwellLabel;
    }

    public void setDwellDelay(int n) {
        this.dwellDelay = n;
    }

    public int getDwellDelay() {
        return this.dwellDelay;
    }

    public JCChart getChart() {
        Container container = this.getParent();
        if (container == null) {
            return null;
        }
        return (JCChart)container;
    }

    public void changeChart(JCChartEvent jCChartEvent) {
        this.recalc();
    }

    public void paintChart(JCChart jCChart) {
    }

    boolean shouldPopupHere(int n, int n2) {
        if (this.attachMethod != 3) {
            return false;
        }
        JCDataIndex jCDataIndex = this.chart.pick(new Point(n, n2), this.getDataView());
        return jCDataIndex != null && jCDataIndex.equals(this.attachDataIndex);
    }
}

